import pandas as pd  
import pickle 
from decision_company import read_csv_file, fetch_column, avg, locate_mode, visit_by_index

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Fetch the 'credit_amount', 'duration', and 'employment' columns  
credit_amount_column = fetch_column(stable_employment, 'credit_amount')  
duration_column = fetch_column(stable_employment, 'duration')  
employment_column = fetch_column(stable_employment, 'employment')  
  
# Calculate the average credit amount and average loan duration  
average_credit_amount = avg(credit_amount_column)  
average_loan_duration = avg(duration_column)  
  
# Find the most common employment status  
most_common_employment = visit_by_index(locate_mode(employment_column),0)  

# Print the summary of common characteristics
print("Average credit amount:", average_credit_amount)
pickle.dump(average_credit_amount,open("./ref_result/average_credit_amount.pkl","wb"))
print("Average loan duration:", average_loan_duration)
pickle.dump(average_loan_duration,open("./ref_result/average_loan_duration.pkl","wb"))
print("Most common employment status:", most_common_employment)
pickle.dump(most_common_employment,open("./ref_result/most_common_employment.pkl","wb"))
